import java.util.*;
import java.awt.Graphics;
import java.awt.Color;
import javax.swing.JPanel;
/*
	

	
*/

public class Board extends JPanel
{
	//public Graphics g;  //global variable g
	public Board()
	{
		
	}
	
	public Board(int boardLength)
	{
		
	}
	int width=30;
	int height = 10;
	char [][] world=new char[height][width];
	char alive='*';        // alive will be represented with a *
	char empty=' ';        // empty locations will be represented by a blank space
	
	public void createBlankWorld(char[][] planet, int width, int height)
	{
		// make all positions empty before starting program
		for(int rows = 0; rows < height; rows++)
		{
			for(int columns = 0; columns < width; columns++)
			{
				planet[rows][columns]=empty;
			}
		}
		
	}
	public void populateWorld(char[][] planet, int width, int height)
	{
		// populate world with 3 groups of 5
		planet[4][2]=alive;
		planet[4][3]=alive;
		planet[4][4]=alive;
		planet[4][5]=alive;
		planet[4][6]=alive;
		
		planet[4][9]=alive;
		planet[4][10]=alive;
		planet[4][11]=alive;
		planet[4][12]=alive;
		planet[4][13]=alive;
		
		planet[4][16]=alive;
		planet[4][17]=alive;
		planet[4][18]=alive;
		planet[4][19]=alive;
		planet[4][20]=alive;
		
	}
	public void randomWorld(char[][] planet, int width, int height)
	{
		// populate world with a 50% density based on chance
		Random generator = new Random();
		int number;
		for(int rows = 1; rows < height-1; rows++)
		{
			for(int columns = 1; columns < width-1; columns++)
			{
				number=generator.nextInt(2)+1;  // determine if location should
				if (number==2)                  //    be occupied
				    planet[rows][columns]=alive;
			}
			
		}
	}
	
	public void densityWorld(char[][] planet, int width, int height)
	{
		// populate world with a given density
		Random generator = new Random();
		int number;
		 Scanner input = new Scanner (System.in);
		 System.out.println("Please enter your density (1-100) ");
        int density = input.nextInt();
		for(int rows = 1; rows < height-1; rows++)
		{
			for(int columns = 1; columns < width-1; columns++)
			{
				number=generator.nextInt(100)+1;
				if (number<density)
				    planet[rows][columns]=alive;
			}
			System.out.println();
		}
	}
	public void showWorld(char[][] planet, int width, int height)
	{
		repaint();
		// display the world
		/*for(int rows = 1; rows < height-1; rows++)
		{
			for(int columns = 1; columns < width-1; columns++)
			{
			
				System.out.print(planet[rows][columns]);
			}
			System.out.println();
		}*/
	}
	public void countNeighbours(char[][] planet, int width, int height)
	{
		
		int count;
		char [][] secondWorld=new char[height][width];
		int rows;
		int columns;
		for(rows = 1; rows < height-1; rows++)
		{
			for( columns = 1; columns < width-1; columns++)
			{
				
				//count the neighbours of one cell
				count=0;
				if (planet[rows-1][columns-1]==alive)
					count++;
				if (planet[rows-1][columns]==alive)
					count++;
				if (planet[rows-1][columns+1]==alive)
					count++;
				if (planet[rows][columns-1]==alive)
					count++;
				if (planet[rows][columns+1]==alive)
					count++;
				if (planet[rows+1][columns-1]==alive)
					count++;
				if (planet[rows+1][columns]==alive)
					count++;
				if (planet[rows+1][columns+1]==alive)
					count++;
				
				
				if (count<2)
					secondWorld[rows][columns]=empty; // die of loneliness
				else if (count==2)
					secondWorld[rows][columns]=planet[rows][columns]; // stay the same
				else if (count==3)
					secondWorld[rows][columns]=alive;  // birth
				else if (count>3)
					secondWorld[rows][columns]=empty;  // die of overcrowding
				
			}
			
			
		}
	// copy new world into old world
		for( rows = 1; rows < height-1; rows++)
		{
			for( columns = 1; columns < width-1; columns++)
			{
				planet[rows][columns]=secondWorld[rows][columns];
			}
		}
	
	}
	
	public void paint (Graphics g)
	{
		super.paintComponent(g);
		g.setColor(Color.RED);
		g.fillOval(10,10, 10, 10);
		// display the world
		// display the world
		for(int rows = 1; rows < height-1; rows++)
		{
			for(int columns = 1; columns < width-1; columns++)
			{
				
				System.out.print(world[rows][columns]);
				if (world[rows][columns]==alive)
				{
					g.setColor(Color.RED);
					g.fillOval(columns*10,10*rows, 10, 10);
				}
				else if (world[rows][columns]==empty)
				{
					g.setColor(Color.WHITE);
					g.fillOval(columns*10,10*rows, 10, 10);
				}
					
				
			}
			System.out.println();
		}
	
		//drawCircle();
	}	
	/*public void paint ()
	{
		super.paintComponent(g);
		g.setColor(Color.RED);
		g.fillOval(10,10, 10, 10);
		//drawCircle();
	}
	/*public void drawCircle()
	{
		g.setColor(Color.RED);
		g.fillOval(10,10, 10, 10);
	}*/
	
}